// Prezentacja referencji konstruktorów
 
// MyFunc jest interfejsem funkcyjnym, którego metoda zwraca 
// referencję MyClass 
interface MyFunc { 
   MyClass func(String s); 
} 
 
class MyClass { 
  private String str; 
 
  // Konstruktor ma jeden parametr 
  MyClass(String s) { str = s; } 
 
  // A to jest konstruktor domyślny 
  MyClass() { str = ""; } 
 
  // ... 
 
  String getStr() { return str; }   
}     
 
class ConstructorRefDemo { 
  public static void main(String[] args) 
  { 
    // Tworzy referencję konstruktora klasy MyClass
    // Ponieważ metoda func() interfejsu MyFunc wymaga przekazania
    // jednego argumentu, new odwołuje się do konstruktora
    // klasy MyClass, który ma parametr, a nie do konstruktora
    // domyślnego
    MyFunc myClassCons = MyClass::new;
 
    // Tworzy instancję klasy MyClass przy użyciu referencji
    // konstruktora
    MyClass mc = myClassCons.func("Testujemy"); 
 
    // Używa utworzonej przed chwilą instancji klasy MyClass
    System.out.println("Łańcuchem w zmiennej mc jest: " + mc.getStr( )); 
  } 
}
