/*
     Przykład 17.1

     Program porównujący pliki
     z interfejsem użytkownika
     wykorzystującym Swing
*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

public class SwingFC implements ActionListener {

  JTextField jtfFirst;  // Przechowuje nazwę pierwszego pliku
  JTextField jtfSecond; // Przechowuje nazwę drugiego pliku

  JButton jbtnComp; // Przycisk porównania plików

  JLabel jlabFirst, jlabSecond; // Wyświetlają zachęty
  JLabel jlabResult; // Wyświetla wynik i komunikaty o błędach

  SwingFC() {

    // Tworzy nowy kontener JFrame
    JFrame jfrm = new JFrame("Porównywanie plików");

    // Wybiera FlowLayout jako menedżer układu
    jfrm.setLayout(new FlowLayout());

    // Nadaje oknu początkowe rozmiary
    jfrm.setSize(200, 190);

    // Aplikacja zakończy działanie na skutek zamknięcia okna
    jfrm.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    // Tworzy pola tekstowe do wprowadzania nazw plików
    jtfFirst = new JTextField(14);
    jtfSecond = new JTextField(14);

    // Wiąże tekst z tymi polami
    jtfFirst.setActionCommand("plikA");
    jtfSecond.setActionCommand("plikB");

    // Tworzy przycisk Porównaj
    JButton jbtnComp = new JButton("Porównaj");

    // Dodaje obiekt nasłuchujący zdarzeń przycisku Porównaj
    jbtnComp.addActionListener(this);

    // Tworzy etykiety
    jlabFirst = new JLabel("Pierwszy plik: ");
    jlabSecond = new JLabel("Drugi plik: ");
    jlabResult = new JLabel("");

    // Umieszcza komponenty w panelu zawartości
    jfrm.add(jlabFirst);
    jfrm.add(jtfFirst);
    jfrm.add(jlabSecond);
    jfrm.add(jtfSecond);
    jfrm.add(jbtnComp);
    jfrm.add(jlabResult);

    // Wyświetla okno
    jfrm.setVisible(true);
  }

  // Porównuje pliki, gdy użytkownik naciśnie przycisk Porównaj
  public void actionPerformed(ActionEvent ae) {
    int i=0, j=0;

    // Najpierw sprawdza, czy wprowadzone zostały nazwy
    // obu plików
    if(jtfFirst.getText().equals("")) {
      jlabResult.setText("Brak nazwy pierwszego pliku.");
      return;
    }
    if(jtfSecond.getText().equals("")) {
      jlabResult.setText("Brak nazwy drugiego pliku.");
      return;
    }

    // Porównuje pliki. Używa rozszerzonej instrukcji try do zarządzania plikami
    try (FileInputStream f1 = new FileInputStream(jtfFirst.getText());
         FileInputStream f2 = new FileInputStream(jtfSecond.getText()))
    {
      // Porównuje zawartość plików
      do {
        i = f1.read();
        j = f2.read();
        if(i != j) break;
      } while(i != -1 && j != -1);

      if(i != j)
        jlabResult.setText("Pliki są różne.");
      else
        jlabResult.setText("Pliki są takie same.");
    } catch(IOException exc) {
      jlabResult.setText("Błąd dostępu do pliku.");
    }
  }

  public static void main(String[] args) {
    // Tworzy okno w wątku rozdziału zdarzeń
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        new SwingFC();
      }
    });
  }
}
