// Zastosowanie tradycyjnej postaci instrukcji switch do określenia metody
// wysyłki skojarzonej z identyfikatorem produktu. Większość produktów jest
// wysyłana w standardowy sposób, jednak niektóre wymagają specjalnego traktowania
class TraditionalSwitch {

  enum ShipMethod { STANDARD, TRUCK, AIR, OVERNIGHT }

  public static void main(String[] args) {
    ShipMethod shipBy;

    int productID = 5099;

    // W tym kodzie do określenia metody wysyłki używamy tradycyjnej 
    // instrukcji switch. Zwróć uwagę na grupowanie klauzul case
    switch(productID) {
      case 1774:
      case 8708:
      case 6709:
        shipBy = ShipMethod.TRUCK;
        break;
      case 4657:
      case 2195:
      case 3621:
      case 1887:
        shipBy = ShipMethod.AIR;
        break;
      case 2907:
      case 5099:
        shipBy = ShipMethod.OVERNIGHT;
        break;
      default:
        shipBy = ShipMethod.STANDARD;
    }

    System.out.println("Produkt o ID " + productID + " jest wysyłany metodą " 
                       + shipBy);
  }
}
