// Użycie wyrażenia switch do pobierania stref czasowych wybranych
// miast w kontynentalnej części USA
class CityTZDemo { 
 
  // Typ wyliczeniowy ze strefami czasowymi
  enum TZ { Eastern, Central, Mountain, Pacific, Other }
 
  public static void main(String[] args) { 

    // Tablica różnych miast w USA
    String[] cities = {
                        "Nowy Jork", "Boston", "Miami", "Chicago",
                        "St. Louis", "Des Moines", "Denver",
                        "Albuquerque", "Seattle", "San Francisco",
                        "Los Angeles", "Portland"
    };


    // Wyświetlamy strefę czasową dla każdego miasta w tablicy
    for(String city: cities) {

      // To wyrażenie switch zwraca wartości typu wyliczeniowego 
      // określające strefę czasową wybranego miasta
      TZ zone = switch(city) {
        case "Nowy Jork", "Boston", "Miami" -> TZ.Eastern;
        case "Chicago", "St. Louis", "Des Moines" -> TZ.Central;
        case "Albuquerque", "Denver" -> TZ.Mountain;
        case "Seattle", "San Francisco", "Los Angeles",
                 "Portland" -> TZ.Pacific;
      
        default -> TZ.Other;
      };

      if(zone == TZ.Other)
        System.out.println("Miasto " + city + " nie leży na kontynencie!");
      else
        System.out.println("Miasto " + city + " znajduje się w strefie czasowej " + zone);
    }
  }
}