// Używa argumentu wieloznacznego 
class NumericFns<T extends Number> { 
  T num; 
    
  // Przekazuje konstruktorowi referencję
  // obiektu numerycznego 
  NumericFns(T n) {  
    num = n; 
  }  
  
  // Zwraca odwrotność 
  double reciprocal() { 
    return 1 / num.doubleValue(); 
  } 
 
  // Zwraca część ułamkową 
  double fraction() { 
    return num.doubleValue() - num.intValue(); 
  } 
 
  // Sprawdza, czy wartości bezwzględne dwóch obiektów są takie same
  boolean absEqual(NumericFns<?> ob) { 
    if(Math.abs(num.doubleValue()) == 
         Math.abs(ob.num.doubleValue())) return true; 
 
    return false; 
  } 
 
  // ... 
}  
  
// Demonstruje użycie argumentu wieloznacznego 
class WildcardDemo {  
  public static void main(String[] args) {  
 
    NumericFns<Integer> iOb = 
                      new NumericFns<Integer>(6);   
 
    NumericFns<Double> dOb = 
                      new NumericFns<Double>(-6.0); 
 
    NumericFns<Long> lOb =  
                      new NumericFns<Long>(5L); 
  
    System.out.println("Sprawdzam iOb i dOb."); 
    if(iOb.absEqual(dOb))
      System.out.println("Wartości bezwzględne są takie same."); 
    else 
      System.out.println("Wartości bezwzględne różnią się."); 
 
    System.out.println(); 
 
    System.out.println("Sprawdzam iOb i lOb."); 
    if(iOb.absEqual(lOb)) 
      System.out.println("Wartości bezwzględne są takie same."); 
    else 
      System.out.println("Wartości bezwzględne różnią się."); 
  
  }
}
