// Prosty przykład użycia rekordów

// Deklaracja typu Item. Jej użycie powoduje automatyczne
// utworzenie klasy rekordu zawierającej prywatne finalne pola
// o nazwach name, itemNum i price oraz metody pobierające o nazwach
// name(), itemNum() i price() umożliwiające odczyt wartości 
// tych pól
record Item(String name, int itemNum, double price) {}

class RecordDemo { 
  public static void main(String[] args) { 
    // Tworzymy tablicę rekordów Item
    Item[] items = new Item[4];

    // Tworzymy listę produktów zapisanych jako rekordy Item.
    // Zwróć uwagę na sposób tworzenia poszczególnych rekordów.
    // Podczas tworzenia rekordu podawane argumenty są automatycznie 
    // zapisywane w polach name, itemNum oraz price
    items[0] = new Item("Młotek", 257, 35.99); 
    items[1] = new Item("Klucz nastawny", 18, 64.15);
    items[2] = new Item("Wiertło", 903, 99.01);
    items[3] = new Item("Piła", 27, 125.11);

    // Zastosowanie metod pobierających do wyświetlenia danych produktów
    for(Item i: items) {
      System.out.println("Produkt " + i.name() + " ma identyfikator " + 
                          i.itemNum() + " i cenę " + i.price());
    }
  }
}
