/* Ta wersja programu umieszcza kod otwierający plik
   i czytający jego zawartość we wspólnym bloku try.
   Plik zostaje zamknięty przez blok finally.
*/

import java.io.*;

class ShowFile2 {
  public static void main(String[] args)
  {
    int i;
    FileInputStream fin = null;

    // Upewnia się, że podano nazwę pliku
    if(args.length != 1) {
      System.out.println("Sposób użycia: ShowFile2 NazwaPliku");
      return;
    }

    // Poniższy kod otwiera plik, wczytuje bajty 
    // do momentu napotkania końca pliku 
    // i zamyka plik w bloku finally
    try {
      fin = new FileInputStream(args[0]);

      do {
        i = fin.read();
        if(i != -1) System.out.print((char) i);
      } while(i != -1);

    } catch(FileNotFoundException exc) {
      System.out.println("Plik nie został znaleziony.");
    } catch(IOException exc) {
      System.out.println("Wystąpił błąd wejścia-wyjścia.");
    } finally {
      // Zawsze zamyka plik
      try {
        if(fin != null) fin.close(); 
      } catch(IOException exc) {
        System.out.println("Błąd podczas zamykania pliku");
      }
    }
  }
}
