/* Wersja programu CopyFile wykorzystująca instrukcję try
  zarządzającą zasobami. Demonstruje zarządzanie dwoma zasobami
  (w tym przypadku plikami) za pomocą pojedynczej instrukcji try.
*/

import java.io.*;

class CopyFile2 {
  public static void main(String[] args) throws IOException 
  {
    int i;

    // Upewnia się, że podano nazwy obu plików
    if(args.length != 2) {
      System.out.println("Sposób użycia: CopyFile2 Źródło Cel");
      return;
    }

    // Otwiera i zamyka dwa pliki za pośrednictwem instrukcji try
    try (FileInputStream fin = new FileInputStream(args[0]);
         FileOutputStream fout = new FileOutputStream(args[1]))
    {

      do {
        i = fin.read();
        if(i != -1) fout.write(i);
      } while(i != -1);

    } catch(IOException exc) {
      System.out.println("Błąd wejścia-wyjścia: " + exc);
    }
  }
}
