// Kolejka znaków o stałym rozmiarze wykorzystująca wyjątki 
class FixedQueue implements ICharQ {  
  private char[] q; // Tablica przechowująca elementy kolejki
  private int putloc, getloc; // Indeksy operacji put i get 
     
  // Tworzy pustą kolejkę o podanym rozmiarze
  public FixedQueue(int size) {  
    q = new char[size]; // Przydziela pamięć kolejce 
    putloc = getloc = 0;     
  }     
    
  // Umieszcza znak w kolejce 
  public void put(char ch) 
    throws QueueFullException { 
 
    if(putloc==q.length)  
      throw new QueueFullException(q.length); 

    q[putloc++] = ch; 
  }     

  // Pobiera znak z kolejki 
  public char get() 
    throws QueueEmptyException {     
 
    if(getloc == putloc)  
      throw new QueueEmptyException(); 
       
    return q[getloc++];     
  }     
}

