// Klasa implementująca kolejkę znaków
class Queue {   
  private char[] q; // Tablica przechowująca elementy kolejki   
  private int putloc, getloc; // Indeksy operacji put i get
   
  // Tworzy pustą kolejkę o podanym rozmiarze
  Queue(int size) {   
    q = new char[size]; // Przydziela pamięć kolejki   
    putloc = getloc = 0;   
  }   
  
  // Tworzy obiekt Queue na podstawie innego obiektu Queue 
  Queue(Queue ob) {  
    putloc = ob.putloc;  
    getloc = ob.getloc;  
    q = new char[ob.q.length];  
  
    // Kopiuje elementy 
    for(int i=getloc; i < putloc; i++)  
      q[i] = ob.q[i];  
  }  
  
  // Tworzy kolejkę, umieszczając w niej elementy
  Queue(char[] a) {  
    putloc = 0;  
    getloc = 0;  
    q = new char[a.length];  
  
    for(int i = 0; i < a.length; i++) put(a[i]);  
  }  

  // Umieszcza znak w kolejce   
  void put(char ch) {   
    if(putloc==q.length) {   
      System.out.println(" -- Kolejka pełna");   
      return;   
    }   
       
    q[putloc++] = ch;   
  }   
   
  // Pobiera znak z kolejki 
  char get() {   
    if(getloc == putloc) {   
      System.out.println(" -- Kolejka pusta");   
      return (char) 0;    
    }   
     
    return q[getloc++];   
  }   
}   
   
// Demonstruje użycie klasy Queue 
class QDemo2 {   
  public static void main(String[] args) {   
    // Tworzy 10-elementową pustą kolejkę 
    Queue q1 = new Queue(10);   
  
    char[] name = {'J', 'a', 'n'};   
    // Tworzy kolejkę na podstawie tablicy
    Queue q2 = new Queue(name);   
  
    char ch;   
    int i;   
   
    // Umieszcza znaki w kolejce q1 
    for(i=0; i < 10; i++)   
      q1.put((char) ('A' + i));   
  
    // Tworzy kolejkę z innej kolejki 
    Queue q3 = new Queue(q1);  
  
    // Wyświetla kolejki 
    System.out.print("Zawartość q1: ");   
    for(i=0; i < 10; i++) {    
      ch = q1.get();   
      System.out.print(ch);   
    }   
   
    System.out.println("\n");   
   
    System.out.print("Zawartość q2: ");   
    for(i=0; i < 3; i++) {    
      ch = q2.get();   
      System.out.print(ch);   
    }   
   
    System.out.println("\n");   
   
    System.out.print("Zawartość q3: ");   
    for(i=0; i < 10; i++) {    
      ch = q3.get();   
      System.out.print(ch);   
    }   
  }   
}
