// Zastosowanie konstruktora niekanonicznego

// Deklaracja rekordu Item
record Item(String name, int itemNum, double price) {
  // Zastosowanie pola statycznego w rekordzie.
  static double pricePending = -1;

  // Konstruktor niekanoniczny. Tworzy on rekord, w którym
  // cena produktu została przekazana jako łańcuch znaków, a nie 
  // wartość typu double. Dlatego ten konstruktor, wywołując konstruktor kanoniczny,
  // musi skonwertować łańcuch do postaci wartości typu double
  public Item(String name, int itemNum, String price) {
    this(name, itemNum, Double.parseDouble(price)); 
  }

}

class RecordDemo3 { 
  public static void main(String[] args) { 
    // Tworzymy tablicę rekordów Item
    Item[] items = new Item[4];

    // Tworzymy listę produktów zapisanych jako rekordy Item.
    // Te dwa produkty będą używać niejawnego konstruktora kanonicznego
    items[0] = new Item("Młotek", 257, 35.99);
    items[1] = new Item("Klucz nastawny", 18, 64.15);

    // Z kolei te dwa produkty zostaną utworzone przy użyciu konstruktora
    // niekanonicznego, gdyż cena jest przekazywana jako String, a nie wartość double
    items[2] = new Item("Wiertło", 903, "99.01");
    items[3] = new Item("Piła", 27, "125.11");

    // Zastosowanie metod pobierających do wyświetlenia danych produktów
    for(Item i: items) {
      System.out.println("Produkt " + i.name() + " ma identyfikator " +
                          i.itemNum() + " i cenę " + i.price());
    }
  }
}
