// Zastosowanie klauzul case ze strzałką i bloków kodu
class BlockArrowCaseDemo {

  enum ShipMethod { STANDARD, TRUCK, AIR, OVERNIGHT }

  public static void main(String[] args) {

    int productID = 5099;

    boolean extraCharge;

    // Zastosowanie bloków kodu w klauzulach case ze strzałką.
    // Ponieważ elementem docelowym klauzuli jest blok kodu,
    // konieczne jest zwrócenie wartości przy użyciu instrukcji yield.
    // Także w tym przypadku nie trzeba używać instrukcji
    // break (ich użycie jest niedozwolone),
    // by zapobiegać przekazywaniu sterowania
    ShipMethod shipBy = switch(productID) {
      case 1774, 8708, 6709 -> {
             extraCharge = true;
             yield ShipMethod.TRUCK; 
          }
      case 4657, 2195, 1887, 3621 -> {
             extraCharge = false;
             yield ShipMethod.AIR;
          }
      case 2907, 5099 -> {
             extraCharge = true;
             yield ShipMethod.OVERNIGHT;
          }
      default -> {
             extraCharge = false;
             yield ShipMethod.STANDARD;
          }
    };

    System.out.println("Produkt o ID " + productID + " jest wysyłany metodą " 
                       + shipBy);
    if(extraCharge) System.out.println("Wymagana jest dopłata");
  }
}
