// Przykład zastosowania tego samego interfejsu funkcyjnego z trzema
// różnymi wyrażeniami lambda.

// Interfejs funkcyjny, którego metoda ma dwa parametry typu int 
// i zwraca wynik typu boolean.
interface NumericTest {
  boolean test(int n, int m);
}

class LambdaDemo2 {
  public static void main(String args[])
  {
    // To wyrażenie lambda sprawdza, czy jedna liczba 
    // jest czynnikiem drugiej.
    NumericTest isFactor = (n, d) -> (n % d) == 0;
    if(isFactor.test(10, 2))
      System.out.println("Liczba 2 jest czynnikiem liczby 10");
    if(!isFactor.test(10, 3))
      System.out.println("Liczba 3 nie jest czynnikiem liczby 10");
    System.out.println();

    // To wyrażenie lambda zwraca true, jeśli pierwszy 
    // argument jest mniejszy od drugiego.
    NumericTest lessThan = (n, m) -> (n < m);
    if(lessThan.test(2, 10))
      System.out.println("Liczba 2 jest mniejsza od liczby 10");
    if(!lessThan.test(10, 2))
      System.out.println("Liczba 10 nie jest mniejsza od liczby 2");
    System.out.println();

    // To wyrażenie lambda zwraca true, jeśli wartości bezwzględne
    // argumentów są sobie równe.
    NumericTest absEqual = (n, m) -> (n < 0 ? -n : n) == (m < 0 ? -m : m);
    if(absEqual.test(4, -4))
      System.out.println("Wartości bezwzględne 4 i -4 są równe.");
    if(!lessThan.test(4, -5))
      System.out.println("Wartości bezwzględne 4 i -5 nie są równe.");
    System.out.println()
  }
}
