// Tworzy wątek, implementując interfejs Runnable.

class MyThread implements Runnable {
  String thrdName;

  MyThread(String name) {
    thrdName = name;
  }

  // Punkt wejściowy wątku.
  public void run() {
    System.out.println(thrdName + " rozpoczyna działanie.");
    try {
      for(int count=0; count < 10; count++) {
        Thread.sleep(400);
        System.out.println(thrdName +
                           " jest wykonywany, wartość licznika: " + count);
      }
    }
    catch(InterruptedException exc) {
      System.out.println(thrdName + " został przerwany.");
    }
    System.out.println(thrdName + " kończy działanie.");
  }
}

class UseThreads {
  public static void main(String args[]) {
    System.out.println("Główny wątek rozpoczyna działanie.");

    // Najpierw tworzy obiekt klasy MyThread.
    MyThread mt = new MyThread("Wątek potomny nr 1");

    // Następnie na jego podstawie tworzy wątek.
    Thread newThrd = new Thread(mt);

    // Na koniec rozpoczyna wykonywanie wątku.
    newThrd.start();

    for(int i=0; i<50; i++) {
      System.out.print(".");
      try {
        Thread.sleep(100);
      }
      catch(InterruptedException exc) {
        System.out.println("Wątek główny został przerwany.");
      }
    }

    System.out.println("Wątek główny kończy działanie.");
  }
}
