class TwoDShape { 
  private double width; 
  private double height; 
 
  // Konstruktor domyślny. 
  TwoDShape() { 
    width = height = 0.0; 
  } 
 
  // Konstruktor z parametrami. 
  TwoDShape(double w, double h) { 
    width = w; 
    height = h; 
  } 
 
  // Tworzy obiekt, którego szerokość jest taka sama jak wysokość. 
  TwoDShape(double x) { 
    width = height = x; 
  } 
 
  // Tworzy obiekt na podstawie innego obiektu. 
  TwoDShape(TwoDShape ob) { 
    width = ob.width; 
    height = ob.height; 
  } 
 
  // Metody dostępowe dla składowych width i height. 
  double getWidth() { return width; } 
  double getHeight() { return height; } 
  void setWidth(double w) { width = w; } 
  void setHeight(double h) { height = h; } 
 
  void showDim() { 
    System.out.println("Szerokość i wysokość: " + 
                       width + " and " + height); 
  } 
} 
 
// Klasa pochodna klasy bazowej TwoDShape reprezentująca trójkąty. 
class Triangle extends TwoDShape { 
  private String style; 
   
  // Konstruktor domyślny. 
  Triangle() { 
    super(); 
    style = "nieokreślony"; 
  } 
 
  // Konstruktor z parametrami. 
  Triangle(String s, double w, double h) { 
    super(w, h); // wywołanie konstruktora klasy bazowej 
 
    style = s;  
  } 
 
  // Konstruktor z jednym parametrem. 
  Triangle(double x) { 
    super(x); // wywołanie konstruktora klasy bazowej
 
    style = "wypełniony";  
  } 
 
  // Tworzy obiekt na podstawie innego obiektu. 
  Triangle(Triangle ob) { 
    super(ob); // przekazuje obiekt konstruktorowi klasy TwoDShape
    style = ob.style; 
  } 
 
  double area() { 
    return getWidth() * getHeight() / 2; 
  } 
 
  void showStyle() { 
    System.out.println("Trójkąt jest " + style); 
  } 
} 
 
class Shapes7 { 
  public static void main(String args[]) { 
    Triangle t1 =  
         new Triangle("pusty", 8.0, 12.0); 
 
    // tworzy kopię obiektu t1 
    Triangle t2 = new Triangle(t1); 
 
    System.out.println("Informacje o t1: "); 
    t1.showStyle(); 
    t1.showDim(); 
    System.out.println("Powierzchnia wynosi " + t1.area()); 
 
    System.out.println(); 
 
    System.out.println("Informacje o t2: "); 
    t2.showStyle(); 
    t2.showDim(); 
    System.out.println("Powierzchnia wynosi " + t2.area()); 
  } 
}
