/* Kopiuje plik tekstowy, zastępując odstępy myślnikami. 

   Ta wersja używa strumieni znakowych. 

   Aby użyć tego programu, podaj nazwę pliku źródłowego   
   oraz nazwę pliku docelowego.  
   Na przykład: 
  
   java Hyphen zrodlo cel 

   Wymaga JDK 7 lub nowszej wersji.
*/

import java.io.*;

class Hyphen2 {
  public static void main(String args[])
    throws IOException
  {
    int i;

    // Sprawdza, czy podano nazwy obu plików.
    if(args.length !=2 ) {
      System.out.println("Sposób użycia: Hyphen zrodlo cel");
      return;
    }

    // Kopiuje zawartość pliku zastępując odstępy myślnikami.
    // Używa wersji instrukcji try zarządzającej zasobem.
    try (FileReader fin = new FileReader(args[0]);
         FileWriter fout = new FileWriter(args[1]))
    {
      do {
        i = fin.read();

        // zamienia odstęp na myślnik
        if((char)i == ' ') i = '-';

        if(i != -1) fout.write(i);
      } while(i != -1);
    } catch(IOException exc) {
      System.out.println("Błąd wejścia/wyjścia: " + exc);
    }
  }
}
