// Klasa implementująca stos znaków.  
class Stack {  
  private char stck[]; // tablica przechowująca elementy stosu 
  private int tos;  // szczyt stosu
  
  // Tworzy pusty stos o podanym rozmiarze. 
  Stack(int size) {  
    stck = new char[size]; // przydziela pamięć stosu 
    tos = 0;  
  }  
 
  // Tworzy stos na podstawie innego stosu. 
  Stack(Stack ob) { 
    tos = ob.tos; 
    stck = new char[ob.stck.length]; 
 
    // kopiuje elementy 
    for(int i=0; i < tos; i++) 
      stck[i] = ob.stck[i]; 
  } 
 
  // Tworzy stos zawierający podane elementy początkowe. 
  Stack(char a[]) { 
    stck = new char[a.length]; 
 
    for(int i = 0; i < a.length; i++) { 
      push(a[i]); 
    }     
  } 
 
    
  // Odkłada znak na stosie. 
  void push(char ch) {  
    if(tos==stck.length) {  
      System.out.println(" -- Stos jest pełen.");  
      return;  
    }  
      
    stck[tos] = ch; 
    tos++; 
  }  
  
  // Zdejmuje znak ze stosu. 
  char pop() {  
    if(tos==0) {  
      System.out.println(" -- Stos jest pusty.");  
      return (char) 0;   
    }  
    
    tos--;  
    return stck[tos];  
  }  
}  
  
// Demonstruje użycie klasy Stack.  
class SDemo {  
  public static void main(String args[]) {  
    // tworzy pusty stos umożliwiający przechowywanie do 10 elementów 
    Stack stk1 = new Stack(10);  
 
    char name[] = {'J', 'a', 'n'};  
   
    // tworzy stos na podstawie tablicy 
    Stack stk2 = new Stack(name);  
 
    char ch;  
    int i;  
  
    // odkłada znaki na stosie stk1  
    for(i=0; i < 10; i++)  
      stk1.push((char) ('A' + i));  
 
    // tworzy stos na podstawie innego stosu 
    Stack stk3 = new Stack(stk1); 
 
    // wyświetla zawartość stosów
    System.out.print("Zawartość stk1: ");  
    for(i=0; i < 10; i++) {   
      ch = stk1.pop();  
      System.out.print(ch);  
    }  
  
    System.out.println("\n");  
  
    System.out.print("Zawartość stk2: ");  
    for(i=0; i < 3; i++) {   
      ch = stk2.pop();  
      System.out.print(ch);  
    }  
  
    System.out.println("\n");  
  
    System.out.print("Zawartość stk3: ");  
    for(i=0; i < 10; i++) {   
      ch = stk3.pop();  
      System.out.print(ch);  
    }  
  }  
}
