/* Ta wersja programu ShowFile używa instrukcji try umożliwiającej
   zarządzanie zasobami do automatycznego zamknięcia pliku.

   Uwaga: Ten wymaga użycia JDK 7 lub nowszej wersji.
*/

import java.io.*;

class ShowFile {
  public static void main(String args[])
  {
    int i;

    // Upewnia się, że podano nazwę pliku.
    if(args.length != 1) {
      System.out.println("Usage: ShowFile filename");
      return;
    }

    // Poniższy kod używa wersji try zarządzającej zasobami
    // do otwarcia pliku, który zostanie automatycznie zamknięty 
    // po zakończeniu bloku try.
    try(FileInputStream fin = new FileInputStream(args[0])) { 

      do {
        i = fin.read();
        if(i != -1) System.out.print((char) i);
      } while(i != -1);

    } catch(IOException exc) {
      System.out.println("Błąd wejścia/wyjścia: " + exc);
    } 
  }
}
