// Wielopoziomowa hierarchia dziedziczenia. 
class TwoDShape { 
  private double width; 
  private double height; 
 
  // Konstruktor domyślny. 
  TwoDShape() { 
    width = height = 0.0; 
  } 
 
  // Konstruktor z parametrami. 
  TwoDShape(double w, double h) { 
    width = w; 
    height = h; 
  } 
 
  // Tworzy obiekt, którego szerokość jest taka sama jak wysokość. 
  TwoDShape(double x) { 
    width = height = x; 
  } 
 
  // Metody dostępowe dla składowych width i height. 
  double getWidth() { return width; } 
  double getHeight() { return height; } 
  void setWidth(double w) { width = w; } 
  void setHeight(double h) { height = h; } 
 
  void showDim() { 
    System.out.println("Szerokość i wysokość: " + 
                       width + " and " + height); 
  } 
} 
 
// Klasa pochodna klasy TwoDShape. 
class Triangle extends TwoDShape { 
  private String style; 
   
  // Konstruktor domyślny. 
  Triangle() { 
    super(); 
    style = "nieokreślony"; 
  } 
 
  Triangle(String s, double w, double h) { 
    super(w, h); // wywołanie konstruktora klasy bazowej 
 
    style = s;  
  } 
 
  // Konstruktor o jednym parametrze. 
  Triangle(double x) { 
    super(x); // wywołanie konstruktora klasy bazowej 
 
    style = "wypełniony";  
  } 
 
  double area() { 
    return getWidth() * getHeight() / 2; 
  } 
 
  void showStyle() { 
    System.out.println("Trójkąt jest " + style); 
  } 
} 
 
// Klasa pochodna klasy Triangle. 
class ColorTriangle extends Triangle { 
  private String color; 
 
  ColorTriangle(String c, String s, 
                double w, double h) { 
    super(s, w, h); 
 
    color = c; 
  } 
 
  String getColor() { return color; } 
 
  void showColor() { 
    System.out.println("Kolor: " + color); 
  } 
} 
 
class Shapes6 { 
  public static void main(String args[]) { 
    ColorTriangle t1 =  
         new ColorTriangle("niebieski", "pusty", 8.0, 12.0); 
    ColorTriangle t2 =  
         new ColorTriangle("czerwony", "wypełniony", 4.0, 2.0); 
 
    System.out.println("Informacje o t1: "); 
    t1.showStyle(); 
    t1.showDim(); 
    t1.showColor(); 
    System.out.println("Powierzchnia wynosi " + t1.area()); 
 
    System.out.println(); 
 
    System.out.println("Informacje o t2: "); 
    t2.showStyle(); 
    t2.showDim(); 
    t2.showColor(); 
    System.out.println("Powierzchnia wynosi " + t2.area()); 
  } 
}
