// Ulepszona wersja symulacji działania sygnalizacji świetlnej
// przechowująca czasy trwania poszczególnych kolorów świateł 
// w obiektach wyliczenia TrafficLightColor. 
 
// Wyliczenie stanów sygnalizatora. 
enum TrafficLightColor {  
  RED(12000), GREEN(10000), YELLOW(2000); 
 
  private int delay; 
 
  TrafficLightColor(int d) { 
    delay = d; 
  } 
 
  int getDelay() { return delay; } 
} 
 
// Skomputeryzowana sygnalizacja świetlna.
class TrafficLightSimulator implements Runnable { 
  private Thread thrd; // referencja wątku wykonującego symulację
  private TrafficLightColor tlc; // przechowuje bieżący kolor światła
  boolean stop = false; // wartość true zatrzymuje symulację
  boolean changed = false; // ma wartość true gdy światło zmieniło się
 
  TrafficLightSimulator(TrafficLightColor init) {  
    tlc = init; 
  } 
 
  TrafficLightSimulator() {  
    tlc = TrafficLightColor.RED; 
  } 
 
  // Rozpoczyna symulację. 
  public void run() { 
    while(!stop) { 
 
      // Zwróć uwagę jak uprościł się ten fragment kodu! 
      try { 
        Thread.sleep(tlc.getDelay()); 
      } catch(InterruptedException exc) { 
        System.out.println(exc); 
      } 
 
      changeColor(); 
    }  
  } 
 
  // Zmienia kolor. 
  synchronized void changeColor() { 
    switch(tlc) { 
      case RED: 
        tlc = TrafficLightColor.GREEN; 
        break; 
      case YELLOW: 
        tlc = TrafficLightColor.RED; 
        break; 
      case GREEN: 
       tlc = TrafficLightColor.YELLOW; 
    } 

    changed = true; 
    notify(); // sygnalizuje, że światło zmieniło się
  } 
 
  // Czeka na zmianę światła. 
  synchronized void waitForChange() { 
    try { 
      while(!changed)
        wait(); // Czeka na zmianę światła.
      changed = false;
    } catch(InterruptedException exc) { 
      System.out.println(exc); 
    } 
  } 
 
  // Zwraca bieżący kolor światła. 
  synchronized TrafficLightColor getColor() { 
    return tlc; 
  } 
 
  // Zatrzymuje sygnalizację. 
  synchronized void cancel() { 
    stop = true; 
  } 
}  
  
class TrafficLightDemo {  
  public static void main(String args[]) {  
    TrafficLightSimulator tl =
      new TrafficLightSimulator(TrafficLightColor.GREEN); 

    Thread thrd = new Thread(tl);
    thrd.start();
 
    for(int i=0; i < 9; i++) { 
      System.out.println(tl.getColor()); 
      tl.waitForChange(); 
    } 
 
    tl.cancel(); 
  }  
}
