// Prezentacja obrotu, skalowania, odbicia i zamazania.
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.scene.control.*;  
import javafx.event.*;  
import javafx.geometry.*;  
import javafx.scene.transform.*; 
import javafx.scene.effect.*; 
import javafx.scene.paint.*; 
  
public class EffectsAndTransformsDemo extends Application {  
  
  double angle = 0.0; 
  double scaleFactor = 0.4; 
  double blurVal = 1.0; 
 
  // Tworzy i inicjuje efekty i transformacje. 
  Reflection reflection = new Reflection(); 
  BoxBlur blur = new BoxBlur(1.0, 1.0, 1); 
  Rotate rotate = new Rotate(); 
  Scale scale = new Scale(scaleFactor, scaleFactor); 
 
  // Tworzy przyciski. 
  Button btnRotate = new Button("Obróć");  
  Button btnBlur = new Button("Zamaż"); 
  Button btnScale = new Button("Przeskaluj"); 
 
  Label reflect = new Label("Odbicie jest zachwycające"); 
 
  public static void main(String[] args) {  
  
    // Uruchamia aplikację JavaFX, wywołując metodę launch(). 
    launch(args);    
  }  
  
  // Przesłonięcie metody start(). 
  public void start(Stage myStage) {  
  
    // Określa tytuł obszaru roboczego.
    myStage.setTitle("Prezentacja efektów i transformacji");  
  
    // Jako korzeń zostaje użyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstępy pomiędzy umieszczonymi
    // w nim kontrolkami będą wynosić 10. 
    FlowPane rootNode = new FlowPane(20, 20);  
  
    // Wyrównuje kontrolki do środka.
    rootNode.setAlignment(Pos.CENTER);  
  
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 300, 120);  
  
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene);  
 
    // Dodaje obrót do listy transformacji przycisku "Obrót".
    btnRotate.getTransforms().add(rotate);  
 
    // Dodaje skalowanie do listy transformacji przycisku "Skalowanie".
    btnScale.getTransforms().add(scale); 
 
    // Dodaje odbicie do listy efektów etykiety.
    reflection.setTopOpacity(0.7); 
    reflection.setBottomOpacity(0.3); 
    reflect.setEffect(reflection); 
 
    // Obsługa zdarzeń przycisku "Obrót".
    btnRotate.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        // Każde kliknięcie przycisku powoduje powiększenie konta
        // obrotu o 15 stopni.
        angle += 15.0; 
 
        rotate.setAngle(angle);        
        rotate.setPivotX(btnRotate.getWidth()/2); 
        rotate.setPivotY(btnRotate.getHeight()/2); 
      }  
    });  
  
    // Obsługa zdarzeń przycisku "Skalowanie".
    btnScale.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        // Każde kliknięcie przycisku powoduje powiększenie 
        // współczynnika przeskalowania.
        scaleFactor += 0.1; 
        if(scaleFactor > 2.0) scaleFactor = 0.4; 
 
        scale.setX(scaleFactor); 
        scale.setY(scaleFactor);         
 
      }  
    });  
 
    // Obsługa zdarzeń przycisku "Zamazanie".
    btnBlur.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        // Każde kliknięcie przycisku powoduje zmianę stopnia zamazania.
        if(blurVal == 10.0) { 
          blurVal = 1.0; 
          btnBlur.setEffect(null); 
          btnBlur.setText("Zamazanie wyłączone"); 
        } else { 
          blurVal++; 
          btnBlur.setEffect(blur);  
          btnBlur.setText("Zamazanie włączone"); 
        } 
        blur.setWidth(blurVal); 
        blur.setHeight(blurVal); 
      }  
    });  
 
    // Dodaje etykietę i kontrolkę listy do grafu sceny.
    rootNode.getChildren().addAll(btnRotate, btnScale, btnBlur, reflect);  
 
    // Wyświetla scenę i obszar roboczy. 
    myStage.show();  
  }  
}
