// Zastosowanie referencji, która może się odwoływać do metody 
// dowolnej instancji. 
 
// Interfejs funkcyjnych przeznaczony dla predykatów liczbowych
// operujący na dowolnym obiekcie MyIntNum oraz wartości typu int.
interface MyIntNumPredicate { 
  boolean test(MyIntNum mv, int n); 
} 
 
// Ta klasa przechowuje wartość typu int i definiuje 
// metodę instancyjną isFactor(), która zwraca true, jeśli
// przekazany argument jest czynnikiem wartości przechowywanej 
// w obiekcie.
class MyIntNum { 
  private int v; 
 
  MyIntNum(int x) { v = x; } 
 
  int getNum() { return v; } 
 
  // Metoda zwraca true, jeśli n jest czynnikiem v.
  boolean isFactor(int n) { 
    return (v % n) == 0; 
  } 
}     
 
class MethodRefDemo3 { 
  public static void main(String args[]) 
  { 
    boolean result; 
 
    MyIntNum myNum = new MyIntNum(12); 
    MyIntNum myNum2 = new MyIntNum(16); 
 
    // Tworzy zmienną inp odwołującą się do metody 
    // instancyjnej isFactor().
    MyIntNumPredicate inp = MyIntNum::isFactor; 
 
    // Poniższy fragment kodu wywołuje metodę isFactor() obiektu myNum.
    result = inp.test(myNum, 3); 
    if(result) 
      System.out.println("3 jest czynnikiem liczby " + myNum.getNum()); 
 
    // Poniższy fragment kodu wywołuje metodę isFactor() obiektu myNum2.
    result = inp.test(myNum2, 3); 
    if(!result) 
      System.out.println("3 nie jest czynnikiem liczby " + myNum2.getNum()); 
  } 
}
