// Bez wywołań metod wait() and notify() .
 
class TickTock { 

  String state; // przechowuje stan zegara
 
  synchronized void tick(boolean running) { 
    if(!running) { // zatrzmuje zegar 
      state = "ticked";
      return; 
    } 
 
    System.out.print("tik "); 

    state = "ticked"; // zmienia stan zegara na "ticked"
  } 
 
  synchronized void tock(boolean running) { 
    if(!running) { // zatrzymuje zegar 
      state = "tocked";
      return; 
    } 
 
    System.out.println("tak"); 

    state = "tocked"; // zmienia stan zegara na "tocked"
  } 
}  
 
class MyThread implements Runnable { 
  Thread thrd; 
  TickTock ttOb; 
 
  // Tworzy nowy wątek. 
  MyThread(String name, TickTock tt) { 
    thrd = new Thread(this, name); 
    ttOb = tt; 
  } 
 
  // Metoda wytwórcza, która tworzy i uruchamia wątek.
  public static MyThread createAndStart(String name, TickTock tt) {
    MyThread myThrd = new MyThread(name, tt);
    
    myThrd.thrd.start(); // uruchamia nowy wątek
    return myThrd;
  }

  // Rozpoczyna wykonywanie nowego wątku. 
  public void run() { 
 
    if(thrd.getName().compareTo("tik") == 0) { 
      for(int i=0; i<5; i++) ttOb.tick(true); 
      ttOb.tick(false); 
    } 
    else { 
      for(int i=0; i<5; i++) ttOb.tock(true); 
      ttOb.tock(false); 
    } 
  } 
} 
 
class ThreadCom2 { 
  public static void main(String args[]) { 
    TickTock tt = new TickTock(); 
    MyThread mt1 = MyThread.createAndStart("tik", tt); 
    MyThread mt2 = MyThread.createAndStart("tak", tt); 
 
    try { 
      mt1.thrd.join(); 
      mt2.thrd.join(); 
    } catch(InterruptedException exc) { 
      System.out.println("Wątek główny został przerwany."); 
    } 
  } 
}
