// Tworzy klasę pochodną klasy Vehicle reprezentującą ciężarówki. 
class Vehicle {    
  private int passengers; // liczba pasażerów
  private int fuelcap;    // pojemność zbiornika paliwa w litrach   
  private double lkm;     // zużycie paliwa w litrach na 100 km   
   
  // Konstruktor klasy Vehicle.  
  Vehicle(int p, int f, double l) {  
    passengers = p;  
    fuelcap = f;  
    lkm = l;  
  }  
 
  // Zwraca zasięg pojazdu.   
  int range() {   
    return (int) (fuelcap / lkm * 100); 
  }   
   
  // Oblicza paliwo potrzebne do przejechania km kilometrów. 
  double fuelneeded(int km) { 
    return (double) km / 100 * lkm; 
  }
 
  // Metody dostępowe dla zmiennych składowych. 
  int getPassengers() { return passengers; } 
  void setPassengers(int p) { passengers = p; } 
  int getFuelcap() { return fuelcap; } 
  void setFuelcap(int f) { fuelcap = f; } 
  double getLkm() { return lkm; } 
  void setMpg(double l) { lkm = l; } 
   
}    
  
// Tworzy klasę Truck jako specjalizację klasy Vehicle.    
class Truck extends Vehicle {  
  private int cargocap; // ładowność w tonach  
  
  // konstruktor klasy Truck.  
  Truck(int p, int f, double l, int c) {  
    /* Używa konstruktora klasy Vehicle
       do inicjalizacji składowych klasy Vehicle. */ 
    super(p, f, l);  
 
    cargocap = c;  
  }  
 
  // Metody dostępowe dla składowej cargocap. 
  int getCargo() { return cargocap; } 
  void putCargo(int c) { cargocap = c; } 
}  
    
class TruckDemo {    
  public static void main(String args[]) {    
  
    // tworzy obiekty reprezentujące ciężarowki 
    Truck semi = new Truck(2, 200, 25, 4);    
    Truck pickup = new Truck(3, 80, 15, 1);    
    double liters;   
    int dist = 252;   
   
    liters = semi.fuelneeded(dist);    
    
    System.out.println("Półciężarówka przewozi " + semi.getCargo() +  
                       " tony ładunku."); 
    System.out.println("Aby pokonać dystans " + dist + " kilometrów, półciężarówka potrzebuje  " +   
                       liters + " litrów paliwa.\n");   
       
    liters = pickup.fuelneeded(dist);    
    
    System.out.println("Pickup przewozi " + pickup.getCargo() +  
                       " tonę ładunku."); 
    System.out.println("Aby pokonać dystans " + dist + " kilometrów, pickup potrzebuje " +   
                       liters + " litrów paliwa.");  
  }    
}
