/* Klasa implementująca tablicę zapobiegającą wyjątkom 
   związanym z przekroczeniem zakresu. 
 */  
class FailSoftArray {  
  private int a[]; // referencja tablicy
  private int errval; // wartość zwracana przez get() w przypadku błędu 
 
  public int length; // składowa length jest publiczna
   
  /* Tworzy tablicę o rozmiarze size, zwracającą wartość errv, 
     gdy wykonanie metody get() zakończy się niepowodzeniem. */ 
  public FailSoftArray(int size, int errv) { 
    a = new int[size]; 
    errval = errv; 
    length = size;  
  } 
 
  // Zwraca element o podanym indeksie. 
  public int get(int index) { 
    if(indexOK(index)) return a[index];            
    return errval; 
  } 
 
  // Umieszcza wartość na podanej pozycji. 
  // Zwraca false w przypadku niepowodzenia. 
  public boolean put(int index, int val) { 
    if(indexOK(index)) { 
      a[index] = val; 
      return true; 
    } 
    return false; 
  } 
 
  // Zwraca true, jeśli index należy do zakresu tablicy. 
  private boolean indexOK(int index) { 
   if(index >= 0 & index < length) return true; 
   return false; 
  } 
}  
  
// Demonstruje użycie klasy FailSoftArray. 
class FSDemo {  
  public static void main(String args[]) {  
    FailSoftArray fs = new FailSoftArray(5, -1); 
    int x; 
 
    // przedstawia sytuację błędnego odwołania
    System.out.println("Przykład błędnego dostępu do tablicy."); 
    for(int i=0; i < (fs.length * 2); i++) 
      fs.put(i, i*10); 
 
    for(int i=0; i < (fs.length * 2); i++) { 
      x = fs.get(i); 
      if(x != -1) System.out.print(x + " "); 
    } 
    System.out.println(""); 
 
    // teraz obsługuje błędny dostęp
    System.out.println("\nKomunikat o błędnym dostępie."); 
    for(int i=0; i < (fs.length * 2); i++) 
      if(!fs.put(i, i*10)) 
        System.out.println("Indeks " + i + " spoza zakresu tablicy"); 
 
    for(int i=0; i < (fs.length * 2); i++) { 
      x = fs.get(i); 
      if(x != -1) System.out.print(x + " "); 
      else 
        System.out.println("Indeks " + i + " spoza zakresu tablicy"); 
    } 
  } 
}
