// Wersja programu do porównywania plików z przykładu 16.1,
// napisana z użyciem JavaFX.
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.scene.control.*;  
import javafx.event.*;  
import javafx.geometry.*;  
import java.io.*; 
  
public class JavaFXFileComp extends Application {  
  
  TextField tfFirst;  // przechowuje nazwę pierwszego pliku
  TextField tfSecond; // przechowuje nazwę drugiego pliku
 
  Button btnComp; // przycisk porównania plików
 
  Label labFirst, labSecond; // wyświetlają zachęty
  Label labResult; // wyświetla wynik i komunikaty o błędach
 
  public static void main(String[] args) {  
  
    // Uruchamia aplikację JavaFX, wywołując metodę launch(). 
    launch(args);    
  }  
  
  // Przesłonięcie metody start(). 
  public void start(Stage myStage) {  
  
    // Określa tytuł obszaru roboczego. 
    myStage.setTitle("Porównywanie plików");  
  
    // Jako korzeń zostaje użyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstępy pomiędzy umieszczonymi
    // w nim kontrolkami będą wynosić 10. 
    FlowPane rootNode = new FlowPane(10, 10);  
  
    // Wyrównuje kontrolki do środka.
    rootNode.setAlignment(Pos.CENTER);  
  
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 180, 180);  
  
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene);  
  
    // Tworzy pola tekstowe do podania nazw plików. 
    tfFirst = new TextField(); 
    tfSecond = new TextField(); 
 
    // Ustawia preferowaną liczbę kolumn w polach. 
    tfFirst.setPrefColumnCount(12); 
    tfSecond.setPrefColumnCount(12); 
 
    // Ustawia etykiety pól tekstowych. 
    tfFirst.setPromptText("Enter file name.");  
    tfSecond.setPromptText("Enter file name.");  
 
    // Tworzy przycisk Porównaj. 
    btnComp = new Button("Porównaj"); 
 
    // Tworzy etykiety.
    labFirst = new Label("Pierwszy plik: "); 
    labSecond = new Label("Drugi plik: "); 
    labResult = new Label(""); 
 
    // Stosuje wyrażenia lambda do obsługi zdarzeń ActionEvent
    // pól tekstowych. W obu przypadkach symulowane jest kliknięcie
    // przycisku Porównaj.
    tfFirst.setOnAction( (ae) -> btnComp.fire());  
    tfSecond.setOnAction( (ae) -> btnComp.fire());  
 
    // Obsługa zdarzeń ActionEvent przycisku Porównaj. 
    btnComp.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        int i=0, j=0; 
 
        // Najpierw upewniamy się, że w obu polach zostały 
        // wpisane nazwy plików.
        if(tfFirst.getText().equals("")) { 
          labResult.setText("Brak nazwy pierwszego pliku."); 
          return; 
        } 
        if(tfSecond.getText().equals("")) { 
          labResult.setText("Brak nazwy drugiego pliku."); 
          return; 
        } 
 
        // Porównuje pliki. Używa rozszerzonej instrukcji try do zarządzania plikami.
        try (FileInputStream f1 = new FileInputStream(tfFirst.getText()); 
             FileInputStream f2 = new FileInputStream(tfSecond.getText())) 
        { 
          // Porównuje zawartość plików.
          do { 
            i = f1.read(); 
            j = f2.read(); 
            if(i != j) break; 
          } while(i != -1 && j != -1); 
 
          if(i != j) 
            labResult.setText("Pliki są różne."); 
          else 
            labResult.setText("Pliki są takie same."); 
 
        } catch(IOException exc) { 
          labResult.setText("Błąd dostępu do pliku."); 
        } 
      } 
    });  
  
    // Dodaje etykietę i przyciski do grafu sceny.
    rootNode.getChildren().addAll(labFirst, tfFirst, labSecond, tfSecond, 
                                  btnComp, labResult);  
  
    // Wyświetla scenę i obszar roboczy.
    myStage.show();  
  }  
}

