/* Kopiuje plik tekstowy, zastępując odstępy myślnikami. 
  
   Ta wersja używa strumieni bajtowych. 
 
   Aby użyć tego programu, podaj nazwę pliku źródłowego   
   oraz nazwę pliku docelowego.  
   Na przykład: 
  
   java Hyphen zrodlo cel 
*/  
 
import java.io.*; 
 
class Hyphen { 
  public static void main(String args[])  
  { 
    int i; 
    FileInputStream fin = null; 
    FileOutputStream fout = null; 

    // Sprawdza, czy podano nazwy obu plików.
    if(args.length !=2 ) {
      System.out.println("Sposób użycia: Hyphen zrodlo cel"); 
      return;
    }
 
    // Kopiuje zawartość pliku zastępując odstępy myślnikami.
    try { 
      fin = new FileInputStream(args[0]); 
      fout = new FileOutputStream(args[1]); 

      do { 
        i = fin.read(); 

        // zamienia odstęp na myślnik
        if((char)i == ' ') i = '-'; 

        if(i != -1) fout.write(i); 
      } while(i != -1); 
    } catch(IOException exc) { 
      System.out.println("Błąd wejścia/wyjścia: " + exc); 
    } finally {
      try {
        if(fin != null) fin.close(); 
      } catch(IOException exc) { 
        System.out.println("Błąd podczas zamykania pliku źródłowego."); 
      } 

      try {
        if(fin != null) fout.close(); 
      } catch(IOException exc) { 
        System.out.println("Błąd podczas zamykania pliku docelowego."); 
      } 
    }
  } 
}
