// Demonstruje prostą metodę sparametryzowaną. 
class GenericMethodDemo {  
 
  // Sprawdza czy zawartość dwóch tablic jest taka sama. 
  static <T extends Comparable<T>, V extends T> boolean arraysEqual(T[] x, V[] y) { 
    // Jeśli tablice mają różną długość, to są różne. 
    if(x.length != y.length) return false; 
 
    for(int i=0; i < x.length; i++) 
      if(!x[i].equals(y[i])) return false; // tablice różnią się 
  
    return true; // zawartość tablic jest identyczna
  } 
 
  public static void main(String args[]) {  
 
    Integer nums[] = { 1, 2, 3, 4, 5 }; 
    Integer nums2[] = { 1, 2, 3, 4, 5 }; 
    Integer nums3[] = { 1, 2, 7, 4, 5 }; 
    Integer nums4[] = { 1, 2, 7, 4, 5, 6 }; 
 
    if(arraysEqual(nums, nums)) 
      System.out.println("tablica nums ma taką samą zawartość jak tablica nums"); 
 
    if(arraysEqual(nums, nums2)) 
      System.out.println("tablica nums ma taką samą zawartość jak tablica nums2"); 
 
    if(arraysEqual(nums, nums3)) 
      System.out.println("tablica nums ma taką samą zawartość jak tablica nums3"); 
 
    if(arraysEqual(nums, nums4)) 
      System.out.println("tablica nums ma taką samą zawartość jak tablica nums4"); 
 
    // Tworzy tablicę obiektów typu Double
    Double dvals[] = { 1.1, 2.2, 3.3, 4.4, 5.5 }; 
 
    // Poniższa instrukcja nie zostanie skompilowana, 
    // ponieważ tablice nums i dvals nie są takiego samego typu.
//    if(arraysEqual(nums, dvals)) 
//      System.out.println("tablica nums ma taką samą zawartość jak tablica dvals"); 
  }  
}
