// Kontrola dostępu do metody sumArray przy 
// wykorzystaniu instrukcji synchronized.

class SumArray { 
  private int sum; 
 
  int sumArray(int nums[]) { 
    sum = 0; // zeruje sumę 
 
    for(int i=0; i<nums.length; i++) { 
      sum += nums[i]; 
      System.out.println(Thread.currentThread().getName() + 
             " wyliczył sumę częściową równą " + sum); 
      try { 
        Thread.sleep(10); // umożliwia przełączenie wątków 
      } 
      catch(InterruptedException exc) { 
        System.out.println("Wątek został przerwany."); 
      } 
    } 
    return sum; 
  } 
}  
 
class MyThread implements Runnable { 
  Thread thrd; 
  static SumArray sa = new SumArray(); 
  int a[]; 
  int answer; 
 
  // Tworzy nowy wątek.
  MyThread(String name, int nums[]) { 
    thrd = new Thread(this, name); 
    a = nums; 
  } 
 
  // Metoda wytwórcza, która tworzy i uruchamia wątek.
  public static MyThread createAndStart(String name, int nums[]) {
    MyThread myThrd = new MyThread(name, nums);
    
    myThrd.thrd.start(); // uruchamia nowy wątek
    return myThrd;
  }

  // Rozpoczyna wykonywanie nowego wątku. 
  public void run() { 
    int sum; 
 
    System.out.println(thrd.getName() + " rozpoczyna działanie."); 
 
    // synchronize calls to sumArray()  
    synchronized(sa) {  
      answer = sa.sumArray(a);           
    }  
    System.out.println(thrd.getName() + 
                       " wyliczył sumę równą " + answer); 
 
    System.out.println(thrd.getName() + " kończy działanie."); 
  } 
} 
 
class Sync { 
  public static void main(String args[]) { 
    int a[] = {1, 2, 3, 4, 5}; 
 
    MyThread mt1 = MyThread.createAndStart("Wątek potomny nr 1", a); 
    MyThread mt2 = MyThread.createAndStart("Wątek potomny nr 2", a); 

    try {
      mt1.thrd.join();
      mt2.thrd.join();
    }
    catch(InterruptedException exc) {
      System.out.println("Wątek główny został przerwany.");
    }

  } 
} 