/*
   Przykład 10.2

   System pomocy wykorzystujący plik
   do przechowywania tematów pomocy.

   Wymaga JDK 7 lub nowszej wersji.
*/

import java.io.*;

/* Klasa Help otwiera plik pomocy,
   wyszukuje temat, a następnie wyświetla
   informacje związane z tym tematem.
   Zwróć uwagę, że sama obsługuje 
   wszystkie wyjątki wejścia/wyjścia. */
class Help {
  String helpfile; // nazwa pliku pomocy

  Help(String fname) {
    helpfile = fname;
  }

  // Wyświetla informacje z pliku pomocy na podany temat.
  boolean helpOn(String what) {
    int ch;
    String topic, info;

    // Otwiera plik pomocy.
    try (BufferedReader helpRdr =
            new BufferedReader(new FileReader(helpfile)))
    {
      do {
        // wczytuje znaki do momentu odnalezienia znaku #
        ch = helpRdr.read();

        // sprawdza czy temat się zgadza
        if(ch == '#') {
          topic = helpRdr.readLine();
          if(what.compareTo(topic) == 0) { // temat znaleziony
            do {
              info = helpRdr.readLine();
              if(info != null) System.out.println(info);
            } while((info != null) &&
                    (info.compareTo("") != 0));
            return true;
          }
        }
      } while(ch != -1);
    }
    catch(IOException exc) {
      System.out.println("Błąd podczas dostępu do pliku pomocy.");
      return false;
    }
    return false; // temat nie został znaleziony
  }

  // Pobiera temat pomocy.
  String getSelection() {
    String topic = "";

    BufferedReader br = new BufferedReader(
              new InputStreamReader(System.in));

    System.out.print("Podaj temat: ");
    try {
      topic = br.readLine();
    }
    catch(IOException exc) {
      System.out.println("Błąd podczas odczytu z konsoli.");
    }
    return topic;
  }
}

// Demonstruje działanie systemu pomocy używającego plik pomocy.
class FileHelp {
  public static void main(String args[]) {
    Help hlpobj = new Help("helpfile.txt");
    String topic;

    System.out.println("Wypróbuj system pomocy. " +
                       "Wprowadź 'stop' aby zakończyć.");
    do {
      topic = hlpobj.getSelection();

      if(!hlpobj.helpOn(topic))
        System.out.println("Temat nie został znaleziony.\n");

    } while(topic.compareTo("stop") != 0);
  }
}
