// Kolejna wersja interfejsu Series, zawierająca tym razem
// dwie metody domyślne oraz metodę prywatną o nazwie getArray();
public interface Series { 
  int getNext(); // Zwraca następną liczbę w serii.

  // Zwraca tablicę zawierającą n następnych elementów 
  // serii.
  default int[] getNextArray(int n) {
    return getArray(n);
  }  

  // Zwraca tablicę zawierającą n następnych elementów
  // serii, po pomięciu podanej liczby elementów.
  default int[] skipAndGetNextArray(int skip, int n) {

    // pominięcie podanej liczby elementów
    getArray(skip);

    return getArray(n);
  }

  // Metoda prywatna, która zwraca tablicę zawierającą
  // kolejnych n elementów serii.
  private int[] getArray(int n) {
    int[] vals = new int[n];

    for(int i=0; i < n; i++) vals[i] = getNext();
    return vals;
  }

  void reset(); // restart 
  void setStart(int x); // określa wartość początkową
}
