// Tworzy klasę abstrakcyjną. 
abstract class TwoDShape {  
  private double width;  
  private double height;  
  private String name;  
  
  // Konstruktor domyślny.  
  TwoDShape() {  
    width = height = 0.0;  
    name = "none";  
  }  
  
  // Konstruktor z parametrami.  
  TwoDShape(double w, double h, String n) {  
    width = w;  
    height = h;  
    name = n;  
  }  
  
  // Tworzy obiekt, którego szerokość jest taka sama jak wysokość.  
  TwoDShape(double x, String n) {  
    width = height = x;  
    name = n;  
  }  
  
  // Tworzy obiekt na podstawie innego obiektu.  
  TwoDShape(TwoDShape ob) {  
    width = ob.width;  
    height = ob.height;  
    name = ob.name;  
  }  
  
  // Metody dostępowe dla składowych width i height.  
  double getWidth() { return width; }  
  double getHeight() { return height; }  
  void setWidth(double w) { width = w; }  
  void setHeight(double h) { height = h; }  
  
  String getName() { return name; }  
  
  void showDim() {  
    System.out.println("Szerokość i wysokość: " +  
                       width + " i " + height);  
  }  
  
  // Teraz metoda area() jest abstrakcyjna. 
  abstract double area(); 
}  
  
// Klasa pochodna klasy bazowej TwoDShape reprezentująca trójkąty. 
class Triangle extends TwoDShape {  
  private String style;  
    
  // Konstruktor domyślny.  
  Triangle() {  
    super();  
    style = "nieokreślony";  
  }  
  
  // Konstruktor z parametrami.  
  Triangle(String s, double w, double h) {  
    super(w, h, "trójkąt");  
  
    style = s;   
  }  
  
  // Konstruktor o jednym parametrze
  Triangle(double x) {  
    super(x, "trójkąt"); // wywołanie konstruktora klasy bazowej
  
    style = "wypełniony";   
  }  
  
  // Tworzy obiekt na podstawie innego obiektu.  
  Triangle(Triangle ob) {  
    super(ob); // przekazuje obiekt konstruktorowi klasy TwoDShape
    style = ob.style;  
  }  
  
  double area() {  
    return getWidth() * getHeight() / 2;  
  }  
  
  void showStyle() {  
    System.out.println("Trójkąt jest " + style);  
  }  
}  
  
// Klasa pochodna klasy bazowej TwoDShape reprezentująca prostokąty.   
class Rectangle extends TwoDShape {   
  // Konstruktor domyślny.  
  Rectangle() {  
    super();  
  }  
  
  // Konstruktor z parametrami.  
  Rectangle(double w, double h) {  
    super(w, h, "prostokąt"); // wywołanie konstruktora klasy bazowej
  }  
  
  // Konstruktor o jednym parametrze.  
  Rectangle(double x) {  
    super(x, "prostokąt"); // wywołanie konstruktora klasy bazowej
  }  
  
  // Tworzy obiekt na podstawie innego obiektu.  
  Rectangle(Rectangle ob) {  
    super(ob); // przekazuje obiekt konstruktorowi klasy TwoDShape
  }  
  
  boolean isSquare() {   
    if(getWidth() == getHeight()) return true;   
    return false;   
  }   
     
  double area() {   
    return getWidth() * getHeight();   
  }   
}  
  
class AbsShape {  
  public static void main(String args[]) {  
    TwoDShape shapes[] = new TwoDShape[4];  
  
    shapes[0] = new Triangle("pusty", 8.0, 12.0);  
    shapes[1] = new Rectangle(10);  
    shapes[2] = new Rectangle(10, 4);  
    shapes[3] = new Triangle(7.0);  
  
    for(int i=0; i < shapes.length; i++) {  
      System.out.println("Typ obiektu: " + shapes[i].getName());  
      System.out.println("Powierzchnia wynosi " + shapes[i].area());  
  
      System.out.println();    
    }  
  }  
}
