// Zastosowanie referencji, ktra moe si odwoywa do metody 
// dowolnej instancji. 
 
// A functional interface for numeric predicates that operate 
// on an object of type MyIntNum and an integer value. 

// Interfejs funkcyjnych przeznaczony dla predykatw liczbowych
// operujcy na dowolnym obiekcie MyIntNum oraz wartoci typu int.
interface MyIntNumPredicate { 
  boolean test(MyIntNum mv, int n); 
} 
 
// Ta klasa przechowuje warto typu int i definiuje 
// metod instancyjn isFactor(), ktra zwraca true, jeli
// przekazany argument jest czynnikiem wartoci przechowywanej 
// w obiekcie.
class MyIntNum { 
  private int v; 
 
  MyIntNum(int x) { v = x; } 
 
  int getNum() { return v; } 
 
  // Metoda zwraca true, jeli n jest czynnikiem v.
  boolean isFactor(int n) { 
    return (v % n) == 0; 
  } 
}     
 
class MethodRefDemo3 { 
  public static void main(String args[]) 
  { 
    boolean result; 
 
    MyIntNum myNum = new MyIntNum(12); 
    MyIntNum myNum2 = new MyIntNum(16); 
 
    // Tworzy zmienn inp odwoujc si do metody 
    // instancyjnej isFactor().
    MyIntNumPredicate inp = MyIntNum::isFactor; 
 
    // Poniszy fragment kodu wywouje metod isFactor() obiektu myNum.
    result = inp.test(myNum, 3); 
    if(result) 
      System.out.println("3 jest czynnikiem liczby " + myNum.getNum()); 
 
    // Poniszy fragment kodu wywouje metod isFactor() obiektu myNum2.
    result = inp.test(myNum2, 3); 
    if(!result) 
      System.out.println("3 nie jest czynnikiem liczby " + myNum2.getNum()); 
  } 
}
