// Tworzenie i stosowanie referencji metod instancyjnych.
 
// Interfejs funkcyjnych przeznaczony dla predykatw liczbowych
// operujcych na wartociach cakowitych.
interface IntPredicate { 
  boolean test(int n); 
} 
 
// Ta klasa przechowuje warto typu int i definiuje 
// metod instancyjn isFactor(), ktra zwraca true, jeli
// przekazany argument jest czynnikiem wartoci przechowywanej 
// w obiekcie.
class MyIntNum { 
  private int v; 
 
  MyIntNum(int x) { v = x; } 
 
  int getNum() { return v; } 
 
  // Metoda zwraca true, jeli n jest czynnikiem v.
  boolean isFactor(int n) { 
    return (v % n) == 0; 
  } 
}     
 
class MethodRefDemo2 { 
 
  public static void main(String args[]) 
  { 
    boolean result; 
 
    MyIntNum myNum = new MyIntNum(12); 
    MyIntNum myNum2 = new MyIntNum(16); 
     
    // Ta instrukcja tworzy referencj metody isFactor obiektu myNum.
    IntPredicate ip = myNum::isFactor; 
 
    // Teraz utworzona wczeniej referencja jest uywana do wywoania 
    // metody isFactor() w metodzie test().
    result = ip.test(3); 
    if(result) System.out.println("3 jest czynnikiem liczby " + myNum.getNum()); 
 
 
    // Ten kod tworzy referencj metody isFactor obiektu myNum2. 
    // Referencja ta jest nastpnie uywana do wywoania metody isFactor()
    // wewntrz metody test(). 
    ip = myNum2::isFactor; 
    result = ip.test(3); 
    if(!result) System.out.println("3 nie jest czynnikiem liczby " + myNum2.getNum()); 
  } 
}
