// Blokowe wyraenie lambda znajdujce najmniejszy dodatni
// czynnik wartoci typu int.
interface NumericFunc {
  int func(int n);
}

class BlockLambdaDemo {
  public static void main(String args[])
  {
    // To blokowe wyraenie lambda zwraca najmniejszy dodatni czynnik
    // przekazanej liczby.
    NumericFunc smallestF = (n) -> {
      int result = 1;
      // Okrela warto bezwzgldn n.
      n = n < 0 ? -n : n;

      for(int i=2; i <= n/i; i++)
        if((n % i) == 0) {
          result = i;
          break;
        }  

      return result;
    };
    System.out.println("Najmniejszym czynnikiem liczby 12 jest " + smallestF.func(12));
    System.out.println("Najmniejszym czynnikiem liczby 11 jest " + smallestF.func(11));
  }
}