// Przykad interfejsu sparametryzowanego.  
  
// Interfejs sparametryzowany wymagajcy, aby klasa, 
// ktra go implementuje zawieraa jedn
// lub wicej wartoci. 
interface Containment<T> { 
  // Metoda contains() sprawdza czy obiekt 
  // implementujcy interfejs Containment
  // zawiera argument wywoanie metody. 
  boolean contains(T o); 
}  
  
// Implementuje interfejs Containment
// za pomoc tablicy. 
class MyClass<T> implements Containment<T> {  
  T[] arrayRef; 
 
  MyClass(T[] o) { 
    arrayRef = o; 
  } 
 
  // Implementacja metody contains(). 
  public boolean contains(T o) { 
    for(T x : arrayRef) 
      if(x.equals(o)) return true; 
    return false; 
  }     
}  
  
class GenIfDemo {  
  public static void main(String args[]) {  
    Integer x[] = { 1, 2, 3 }; 
 
    MyClass<Integer> ob = new MyClass<Integer>(x); 
 
    if(ob.contains(2)) 
      System.out.println("ob zawiera 2"); 
    else 
      System.out.println("ob NIE zawiera 2"); 
 
    if(ob.contains(5)) 
      System.out.println("ob zawiera 5"); 
    else 
      System.out.println("ob NIE zawiera 5"); 
 
    // Ponisza instrukcja jest niedozwolona
    // poniewa ob implementuje interfejs Containment 
    // dla typu Integer, a 9.25 jest wartoci typu Double. 
//    if(ob.contains(9.25)) // Niedozwolona! 
//      System.out.println("ob zawiera 9.25"); 
 
  } 
}
