/* Zapisuje a nastpnie odczytuje dane binarne.

   Wymaga JDK 7 lub nowszej wersji.
*/

import java.io.*;

class RWData {
  public static void main(String args[])
  {
    int i = 10;
    double d = 1023.56;
    boolean b = true;

    // Zapisuje pewne wartoci.
    try (DataOutputStream dataOut =
             new DataOutputStream(new FileOutputStream("testdata")))
    {
      System.out.println("Zapisuj " + i);
      dataOut.writeInt(i);

      System.out.println("Zapisuj " + d);
      dataOut.writeDouble(d);

      System.out.println("Zapisuj " + b);
      dataOut.writeBoolean(b);

      System.out.println("Zapisuj " + 12.2 * 7.4);
      dataOut.writeDouble(12.2 * 7.4);
    }
    catch(IOException exc) {
      System.out.println("Bd zapisu.");
      return;
    }

    System.out.println();

    // Teraz odczytuje zapisane wartoci.
    try (DataInputStream dataIn = 
             new DataInputStream(new FileInputStream("testdata")))
    {
      i = dataIn.readInt();
      System.out.println("Odczytuj " + i);

      d = dataIn.readDouble();
      System.out.println("Odczytuj " + d);

      b = dataIn.readBoolean();
      System.out.println("Odczytuj " + b);

      d = dataIn.readDouble();
      System.out.println("Odczytuj " + d);
    }
    catch(IOException exc) {
      System.out.println("Bd odczytu.");
    }
  }
}
