// Prezentacja stosowania przyciskw i obsugi zdarze 
// w aplikacji JavaFX. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
 
public class JavaFXEventDemo extends Application { 
 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Uruchamia aplikacj JavaFX, wywoujc metod launch(). 
    launch(args);   
  } 
 
  // Przesonicie metody start(). 
  public void start(Stage myStage) { 
 
    // Okrela tytu obszaru roboczego. 
    myStage.setTitle("Przyciski i zdarzenia JavaFX"); 
 
    // Jako korze zostaje uyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstpy pomidzy umieszczonymi
    // w nim kontrolkami bd wynosi 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrwnuje kontrolki do rodka.
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 300, 100); 
 
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene); 
 
    // Tworzy etykiet. 
    response = new Label("Przycisk"); 
 
    // Tworzy dwa przyciski. 
    Button btnUp = new Button("Gra"); 
    Button btnDown = new Button("D"); 
 
    // Obsuga zdarzenia ActionEvent przycisku Gra.
    btnUp.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Nacisne przycisk Gra."); 
      } 
    }); 
 
    // Obsuga zdarzenia ActionEvent przycisku D.
    btnDown.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Nacisne przycisk D."); 
      } 
    }); 
 
    // Dodaje etykiet i przyciski do grafu sceny.
    rootNode.getChildren().addAll(btnUp, btnDown, response); 
 
    // Wywietla scen i obszar roboczy.
    myStage.show(); 
  } 
}
