// Przykad przechwytywania zmiennych lokalnych z zasigu, w ktrym
// wyraenie lambda zostao zdefiniowane.
 
interface MyFunc { 
  int func(int n); 
} 
 
class VarCapture { 
  public static void main(String args[]) 
  { 
    // Zmienna lokalna, ktr mona przechwyci.
    int num = 10; 
 
    MyFunc myLambda = (n) ->  { 
      // To prawidowy sposb uycia zmiennej num.
      // Jej warto nie jest bowiem modyfikowana.
      int v = num + n; 
 
      // Z kolei ta instrukcja jest nieprawidowa, gdy 
      // prbuje zmieni warto zmiennej num. 
   // num++; 
 
      return v; 
    }; 
 
    // Uywamy wyraenia lambda. Zostanie wywietlona
    // warto 18. 
    System.out.println(myLambda.func(8)); 
 
    // Take ta instrukcja spowoduje zgoszenie bdu, gdy 
    // powoduje ona, e zmienna num traci status zmiennej 
    // praktycznie sfinalizowanej.
 // num = 9; 
  } 
}
