// Prezentacja uycia metody Platform.exit().  
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.scene.control.*;  
import javafx.event.*;  
import javafx.geometry.*;  
  
public class JavaFXEventDemo extends Application {  
  
  Label response;  
  
  public static void main(String[] args) {  
  
    // Uruchamia aplikacj JavaFX, wywoujc metod launch().  
    launch(args);    
  }  
  
  // Przesonicie metody start(). 
  public void start(Stage myStage) {  
  
    // Okrela tytu obszaru roboczego. 
    myStage.setTitle("Zastosowanie metody Platform.exit()");  
  
    // Jako korze zostaje uyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstpy pomidzy umieszczonymi
    // w nim kontrolkami bd wynosi 10. 
    FlowPane rootNode = new FlowPane(10, 10);  
  
    // Wyrwnuje kontrolki do rodka.
    rootNode.setAlignment(Pos.CENTER);  
  
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 300, 100);  
  
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene);  
  
    // Tworzy etykiet. 
    response = new Label("Nacinij przycisk");  
  
    // Tworzy dwa przyciski. 
    Button btnRun = new Button("Uruchom");  
    Button btnExit = new Button("Zakocz");  
  
    // Obsuga zdarzenia ActionEvent przycisku Uruchom.
    btnRun.setOnAction((ae) -> response.setText("Klikne przycisk Uruchom.")); 
  
    // Obsuga zdarzenia ActionEvent przycisku Zakocz.
    btnExit.setOnAction((ae) -> Platform.exit());  
  
    // Dodaje etykiet i przyciski do grafu sceny.
    rootNode.getChildren().addAll(btnRun, btnExit, response);  
  
    // Wywietla scen i obszar roboczy.
    myStage.show();  
  }  
}