// Klasa implementujca kolejk znakw.   
class Queue {   
  private char q[]; // tablica przechowujca elementy kolejki   
  private int putloc, getloc; // indeksy operacji put i get
   
  // Tworzy pust kolejk o podanym rozmiarze.  
  Queue(int size) {   
    q = new char[size+1]; // przydziela pami kolejki   
    putloc = getloc = 0;   
  }   
  
  // Tworzy obiekt Queue na podstawie innego obiektu Queue.  
  Queue(Queue ob) {  
    putloc = ob.putloc;  
    getloc = ob.getloc;  
    q = new char[ob.q.length];  
  
    // kopiuje elementy  
    for(int i=getloc+1; i <= putloc; i++)  
      q[i] = ob.q[i];  
  }  
  
  // Tworzy kolejk umieszczajc w niej elementy.  
  Queue(char a[]) {  
    putloc = 0;  
    getloc = 0;  
    q = new char[a.length+1];  
  
    for(int i = 0; i < a.length; i++) put(a[i]);  
  }  
      
  // umieszcza znak w kolejce.   
  void put(char ch) {   
    if(putloc==q.length-1) {   
      System.out.println(" -- Kolejka pena.");   
      return;   
    }   
       
    putloc++;   
    q[putloc] = ch;   
  }   
   
  // Pobiera znak z kolejki.  
  char get() {   
    if(getloc == putloc) {   
      System.out.println(" -- Kolejka pusta.");   
      return (char) 0;    
    }   
     
    getloc++;   
    return q[getloc];   
  }   
}   
   
// Demonstruje uycie klasy Queue.   
class QDemo2 {   
  public static void main(String args[]) {   
    // tworzy 10-elementow pust kolejk  
    Queue q1 = new Queue(10);   
  
    char name[] = {'J', 'a', 'n'};   
    // tworzy kolejk na podstawie tablicy
    Queue q2 = new Queue(name);   
  
    char ch;   
    int i;   
   
    // umieszcza znaki w kolejce q1   
    for(i=0; i < 10; i++)   
      q1.put((char) ('A' + i));   
  
    // tworzy kolejk z innej kolejki  
    Queue q3 = new Queue(q1);  
  
    // Wywietla kolejki.  
    System.out.print("Zawarto q1: ");   
    for(i=0; i < 10; i++) {    
      ch = q1.get();   
      System.out.print(ch);   
    }   
   
    System.out.println("\n");   
   
    System.out.print("Zawarto q2: ");   
    for(i=0; i < 3; i++) {    
      ch = q2.get();   
      System.out.print(ch);   
    }   
   
    System.out.println("\n");   
   
    System.out.print("Zawarto q3: ");   
    for(i=0; i < 10; i++) {    
      ch = q3.get();   
      System.out.print(ch);   
    }   
  }   
}
