// Generyczna wersja stosu. 
 
interface IGenStack<T> { 
  void push(T obj) throws StackFullException; 
  T pop() throws StackEmptyException; 
} 
 
// Wyjtek przepenienia stosu.  
class StackFullException extends Exception {   
  int size;   
     
  StackFullException(int s) { size = s; }   
   
  public String toString() {   
   return "\nStos jest peen. Maksymalny rozmiar: " +   
           size;   
  }   
}   
   
// Wyjtek oprnienia stosu.  
class StackEmptyException extends Exception { 
   
  public String toString() {   
   return "\nStos jest pusty.";   
  }   
}   
   
// Generyczna klas stosu.     
class GenStack<T> implements IGenStack<T> {  
  private T stck[]; // tablica przechowujca elementy stosu 
  private int tos;  // szczyt stosu   
     
  // Tworzy stos wykorzystujc podan tablic. 
  GenStack(T[] stckArray) {     
    stck = stckArray; 
    tos = 0;     
  }     
    
  // Tworzy stos na podstawie innego stosu.
  GenStack(T[] stckArray, GenStack<T> ob) { 
 
    tos = ob.tos;    
    stck = stckArray; 
 
    try { 
      if(stck.length < ob.stck.length) 
        throw new StackFullException(stck.length); 
    } 
    catch(StackFullException exc) {   
      System.out.println(exc);   
    }   
    
    // kopiuje elementy   
    for(int i=0; i < tos; i++)    
      stck[i] = ob.stck[i];    
  }    
    
  // Tworzy stos zawierajcy podane elementy pocztkowe. 
  GenStack(T[] stckArray, T[] a) {    
    stck = stckArray; 
    
    for(int i = 0; i < a.length; i++) {    
      try {   
        push(a[i]);    
      }    
      catch(StackFullException exc) {   
        System.out.println(exc);   
      }   
    }        
  }    
       
  // Odkada obiekt na stosie.
  public void push(T obj) throws StackFullException {     
    if(tos==stck.length)   
      throw new StackFullException(stck.length);   
  
    stck[tos] = obj;    
    tos++;    
  }     
     
  // Zdejmuje obiekt ze stosu. 
  public T pop() throws StackEmptyException {     
    if(tos==0)     
      throw new StackEmptyException();   
       
    tos--;     
    return stck[tos];     
  }     
} 
 
// Demonstruje generyczn klas stosu.   
class GenStackDemo {   
  public static void main(String args[]) {   
    // Tworzy pusty stos umoliwiajcy przechowanie 
    // do 10 elementw typu Integer. 
    Integer iStore[] = new Integer[10]; 
    GenStack<Integer> stk1 = new GenStack<Integer>(iStore); 
  
    // Tworzy stos zawierajcy podane elementy. 
    String name[] = {"Raz", "Dwa", "Trzy"};   
    String strStore[] = new String[3]; 
    GenStack<String> stk2 = 
        new GenStack<String>(strStore, name); 
  
    String str; 
    int n;   
 
    try { 
   
      // Umieszcza wartoci na stosie stk1. 
      for(int i=0; i < 10; i++)   
        stk1.push(i); 
    } catch(StackFullException exc) { 
      System.out.println(exc); 
    } 
  
    // Tworzy stos na podstawie innego stosu. 
    String strStore2[] = new String[3]; 
    GenStack<String> stk3 =  
        new GenStack<String>(strStore2, stk2);  
 
    try {  
      // Wywietla zawartoci stosw.  
      System.out.print("Zawarto stosu stk1: ");   
      for(int i=0; i < 10; i++) {    
        n = stk1.pop();   
        System.out.print(n + " ");   
      }   
   
      System.out.println("\n");   
   
      System.out.print("Zawarto stosu stk2: ");   
      for(int i=0; i < 3; i++) {    
        str = stk2.pop();   
        System.out.print(str + " "); 
      }   
   
      System.out.println("\n");   
   
      System.out.print("Zawarto stosu stk3: ");   
      for(int i=0; i < 3; i++) {    
        str = stk3.pop(); 
        System.out.print(str + " "); 
      }   
 
    } catch(StackEmptyException exc) { 
      System.out.println(exc); 
    } 
 
    System.out.println(); 
  }   
}
