/* Kopiuje plik tekstowy, zastpujc odstpy mylnikami. 

   Ta wersja uywa strumieni znakowych. 

   Aby uy tego programu, podaj nazw pliku rdowego   
   oraz nazw pliku docelowego.  
   Na przykad: 
  
   java -Dfile.encoding=CP852 Hyphen zrodlo cel 

   Wymaga JDK 7 lub nowszej wersji.
*/

import java.io.*;

class Hyphen2 {
  public static void main(String args[])
    throws IOException
  {
    int i;

    // Sprawdza, czy podano nazwy obu plikw.
    if(args.length !=2 ) {
      System.out.println("Sposb uycia: Hyphen zrodlo cel");
      return;
    }

    // Kopiuje zawarto pliku zastpujc odstpy mylnikami.
    // Uywa wersji instrukcji try zarzdzajcej zasobem.
    try (FileReader fin = new FileReader(args[0]);
         FileWriter fout = new FileWriter(args[1]))
    {
      do {
        i = fin.read();

        // zamienia odstp na mylnik
        if((char)i == ' ') i = '-';

        if(i != -1) fout.write(i);
      } while(i != -1);
    } catch(IOException exc) {
      System.out.println("Bd wejcia/wyjcia: " + exc);
    }
  }
}
