// Wstrzymywanie, wznawianie i zatrzymywanie wtku. 
 
class MyThread implements Runnable {  
  Thread thrd;  
  boolean suspended;  
  boolean stopped; 
    
  MyThread(String name) {  
    thrd = new Thread(this, name);  
    suspended = false;  
    stopped = false; 
    thrd.start();  
  }  
  
  // Punkt wejcia do wtku.  
  public void run() {  
    System.out.println(thrd.getName() + " rozpoczyna dziaanie."); 
    try {  
      for(int i = 1; i < 1000; i++) {  
        System.out.print(i + " ");  
        if((i%10)==0) { 
          System.out.println(); 
          Thread.sleep(250); 
        } 
 
        // Uywa bloku synchronized aby sprawdzi 
        // wartoi skadowych suspended i stopped. 
        synchronized(this) {  
          while(suspended) {  
            wait();  
          }  
          if(stopped) break; 
        }  
      }  
    } catch (InterruptedException exc) {  
      System.out.println(thrd.getName() + " zosta przerwany.");  
    }  
    System.out.println(thrd.getName() + " koczy dziaanie.");  
  }  
 
  // Zatrzymuje wtek.  
  synchronized void mystop() {  
    stopped = true;  
 
   // Ponisze instrukcje umoliwiaj zatrzymanie wtku,
   // ktrego wykonanie zostao wstrzymane. 
    suspended = false; 
    notify(); 
  }  
 
  // Wstrzymuje dziaanie wtku. 
  synchronized void mysuspend() {  
    suspended = true;  
  }  
 
  // Wznawia dziaanie wtku.  
  synchronized void myresume() {  
    suspended = false;  
    notify();  
  }  
}  
  
class Suspend {  
  public static void main(String args[]) {  
    MyThread ob1 = new MyThread("Wtek potomny klasy MyThread");  
 
    try {  
      Thread.sleep(1000); // let ob1 thread start executing 
  
      ob1.mysuspend();  
      System.out.println("Wstrzymuj wtek.");  
      Thread.sleep(1000); 
 
      ob1.myresume();  
      System.out.println("Wznawiam wtek.");  
      Thread.sleep(1000); 
 
 
      ob1.mysuspend();  
      System.out.println("Wstrzymuj wtek.");  
      Thread.sleep(1000); 
 
      ob1.myresume();  
      System.out.println("Wznawiam wtek.");  
      Thread.sleep(1000); 
 
      ob1.mysuspend();  
      System.out.println("Zatrzymuj wtek."); 
      ob1.mystop(); 
    } catch (InterruptedException e) {  
      System.out.println("Wtek gwny zosta przerwany");  
    }  
  
    // czeka na zakoczenie wtku  
    try {  
      ob1.thrd.join();  
    } catch (InterruptedException e) {  
      System.out.println("Wtek gwny zosta przerwany");  
    }  
   
    System.out.println("Wtek gwny koczy dziaanie.");  
  }  
}