// Uywa mechanzmu dynamicznego wyboru metody.  
class TwoDShape {  
  private double width;  
  private double height;  
  private String name;  
  
  // Konstruktor domylny.  
  TwoDShape() {  
    width = height = 0.0;  
    name = "none";  
  }  
  
  // Konstruktor z parametrami.  
  TwoDShape(double w, double h, String n) {  
    width = w;  
    height = h;  
    name = n;  
  }  
  
  // Tworzy obiekt, ktrego szeroko jest taka sama jak wysoko.  
  TwoDShape(double x, String n) {  
    width = height = x;  
    name = n;  
  }  
  
  // Tworzy obiekt na podstawie innego obiektu.  
  TwoDShape(TwoDShape ob) {  
    width = ob.width;  
    height = ob.height;  
    name = ob.name;  
  }  
  
  // Metody dostpowe dla skadowych width i height.  
  double getWidth() { return width; }  
  double getHeight() { return height; }  
  void setWidth(double w) { width = w; }  
  void setHeight(double h) { height = h; }  
  
  String getName() { return name; }  
  
  void showDim() {  
    System.out.println("Szeroko i wysoko: " +  
                       width + " i " + height);  
  }  
  
  double area() {   
    System.out.println("area() musi by przesonita w klasach pochodnych");  
    return 0.0;  
  }   
}  
  
// Klasa pochodna klasy bazowej TwoDShape reprezentujca trjkty. 
class Triangle extends TwoDShape {  
  private String style;  
    
  // Konstruktor domylny.  
  Triangle() {  
    super();  
    style = "nieokrelony";  
  }  
  
  // Konstruktor z parametrami.  
  Triangle(String s, double w, double h) {  
    super(w, h, "trjkt");  
  
    style = s;   
  }  
  
  // Konstruktor o jednym parametrze. 
  Triangle(double x) {  
    super(x, "trjkt"); // wywoanie konstruktora klasy bazowej
  
    style = "wypeniony";   
  }  
  
  // Tworzy obiekt na podstawie innego obiektu.  
  Triangle(Triangle ob) {  
    super(ob); // przekazuje obiekt konstruktorowi klasy TwoDShape
    style = ob.style;  
  }  
  
  // Przesania area() w klasie Triangle. 
  double area() {  
    return getWidth() * getHeight() / 2;  
  }  
  
  void showStyle() {  
    System.out.println("Trjkt jest" + style);  
  }  
}  
  
// Klasa pochodna klasy bazowej TwoDShape reprezentujca prostokty.   
class Rectangle extends TwoDShape {   
  // Konstruktor domylny.  
  Rectangle() {  
    super();  
  }  
  
  // Konstruktor z parametrami.  
  Rectangle(double w, double h) {  
    super(w, h, "prostokt"); // wywoanie konstruktora klasy bazowej
  }  
  
  // Konstruktor o jednym parametrze.  
  Rectangle(double x) {  
    super(x, "prostokt"); // wywoanie konstruktora klasy bazowej
  }  
  
  // Tworzy obiekt na podstawie innego obiektu.  
  Rectangle(Rectangle ob) {  
    super(ob); // przekazuje obiekt konstruktorowi klasy TwoDShape
  }  
  
  boolean isSquare() {   
    if(getWidth() == getHeight()) return true;   
    return false;   
  }   
     
  // Przesania area() w klasie Rectangle. 
  double area() {   
    return getWidth() * getHeight();   
  }   
}  
  
class DynShapes {  
  public static void main(String args[]) {  
    TwoDShape shapes[] = new TwoDShape[5];  
  
    shapes[0] = new Triangle("pusty", 8.0, 12.0);  
    shapes[1] = new Rectangle(10);  
    shapes[2] = new Rectangle(10, 4);  
    shapes[3] = new Triangle(7.0);  
    shapes[4] = new TwoDShape(10, 20, "oglny"); 
  
    for(int i=0; i < shapes.length; i++) {  
      System.out.println("Typ obiektu: " + shapes[i].getName());  
      System.out.println("Powierzchnia wynosi " + shapes[i].area());  
  
      System.out.println();    
    }  
  }  
}
