// Demonstruje obsug zdarze myszy. 
import java.awt.*; 
import java.awt.event.*; 
import java.applet.*; 
/* 
  <applet code="MouseEvents" width=300 height=100> 
  </applet> 
*/ 
 
public class MouseEvents extends Applet 
  implements MouseListener, MouseMotionListener { 
 
  String msg = ""; 
  int mouseX = 0, mouseY = 0; // wsprzdne myszy
 
  public void init() { 
     addMouseListener(this); 
     addMouseMotionListener(this); 
  } 
 
  // Obsuguje kliknicie myszy. 
  public void mouseClicked(MouseEvent me) { 
    mouseX = 0; 
    mouseY = 10; 
    msg = "Kliknicie myszy."; 
    repaint(); 
  } 
 
  // Obsuguje zdarzenie polegajce
  // na wprowadzeniu myszy w obszar komponentu. 
  public void mouseEntered(MouseEvent me) { 
    mouseX = 0; 
    mouseY = 10; 
    msg = "Mysz w obszarze komponentu."; 
    repaint(); 
  } 
 
  // Obsuguje zdarzenie polegajce
  // na opuszczeniu komponentu.
  public void mouseExited(MouseEvent me) { 
    mouseX = 0; 
    mouseY = 10; 
    msg = "Mysz opucia komponent."; 
    repaint(); 
  } 
 
  // Obsuguje nacinicie klawisza. 
  public void mousePressed(MouseEvent me) { 
    // save coordinates 
    mouseX = me.getX(); 
    mouseY = me.getY(); 
    msg = "D"; 
    repaint(); 
  } 
 
  // Obsuguje zwolnienie klawisza. 
  public void mouseReleased(MouseEvent me) { 
    // save coordinates 
    mouseX = me.getX(); 
    mouseY = me.getY(); 
    msg = "Gra"; 
    repaint(); 
  } 
 
  // Obsuguje przeciganie myszy. 
  public void mouseDragged(MouseEvent me) { 
    // save coordinates 
    mouseX = me.getX(); 
    mouseY = me.getY(); 
    msg = "*"; 
    showStatus("Mysz przecigana, pozycja " + mouseX + ", " + mouseY); 
    repaint(); 
  } 
 
  // Obsuguje ruch myszy. 
  public void mouseMoved(MouseEvent me) { 
    // show status 
    showStatus("Przesunicie myszy, pozycja " + me.getX() + ", " + me.getY()); 
  } 
 
  // Wywietla komunikat msg w oknie apletu
  // na biecej pozycji kursora myszy. 
  public void paint(Graphics g) { 
    g.drawString(msg, mouseX, mouseY); 
  } 
}
