// Uywa metod wait() and notify() 
// do stworzenia symulacji zegara. 
 
class TickTock { 

  String state; // przechowuje stan zegara
 
  synchronized void tick(boolean running) { 
    if(!running) { // zatrzmuje zegar 
      state = "ticked";
      notify(); // powiadamia oczekujcy wtek 
      return; 
    } 
 
    System.out.print("tik "); 

    state = "ticked"; // zmienia stan zegara na "ticked"

    notify(); // umoliwia wykonanie metody tock() 
    try { 
      while(!state.equals("tocked"))
        wait(); // oczekuje na zakoczenie metody tock()
    } 
    catch(InterruptedException exc) { 
      System.out.println("Wtek zosta przerwany."); 
    } 
  } 
 
  synchronized void tock(boolean running) { 
    if(!running) { // zatrzymuje zegar 
      state = "tocked";
      notify(); // powiadamia oczekujcy wtek 
      return; 
    } 
 
    System.out.println("tak"); 

    state = "tocked"; // zmienia stan zegara na "tocked"

    notify(); // umoliwia wykonanie metody tick() 
    try { 
      while(!state.equals("ticked"))
        wait(); // oczekuje na zakoczenie metody tick()
    } 
    catch(InterruptedException exc) { 
      System.out.println("Wtek zosta przerwany."); 
    } 
  } 
}  
 
class MyThread implements Runnable { 
  Thread thrd; 
  TickTock ttOb; 
 
  // Tworzy nowy wtek. 
  MyThread(String name, TickTock tt) { 
    thrd = new Thread(this, name); 
    ttOb = tt; 
    thrd.start(); // uruchamia wtek 
  } 
 
  // Rozpoczyna wykonywanie nowego wtku. 
  public void run() { 
 
    if(thrd.getName().compareTo("tik") == 0) { 
      for(int i=0; i<5; i++) ttOb.tick(true); 
      ttOb.tick(false); 
    } 
    else { 
      for(int i=0; i<5; i++) ttOb.tock(true); 
      ttOb.tock(false); 
    } 
  } 
} 
 
class ThreadCom { 
  public static void main(String args[]) { 
    TickTock tt = new TickTock(); 
    MyThread mt1 = new MyThread("tik", tt); 
    MyThread mt2 = new MyThread("tak", tt); 
 
    try { 
      mt1.thrd.join(); 
      mt2.thrd.join(); 
    } catch(InterruptedException exc) { 
      System.out.println("Wtek gwny zosta przerwany."); 
    } 
  } 
}
