/* Ta wersja programu ShowFile uywa instrukcji try umoliwiajcej
   zarzdzanie zasobami do automatycznego zamknicia pliku.

   Uwaga: Ten wymaga uycia JDK 7 lub nowszej wersji.
*/

import java.io.*;

class ShowFile {
  public static void main(String args[])
  {
    int i;

    // Upewnia si, e podano nazw pliku.
    if(args.length != 1) {
      System.out.println("Usage: ShowFile filename");
      return;
    }

    // Poniszy kod uywa wersji try zarzdzajcej zasobami
    // do otwarcia pliku, ktry zostanie automatycznie zamknity 
    // po zakoczeniu bloku try.
    try(FileInputStream fin = new FileInputStream(args[0])) { 

      do {
        i = fin.read();
        if(i != -1) System.out.print((char) i);
      } while(i != -1);

    } catch(IOException exc) {
      System.out.println("Bd wejcia/wyjcia: " + exc);
    } 
  }
}
