/*  
   Wprowadza obsug wyjtkw w klasie kolejki. 
*/
 
// Wyjtek penej kolejki. 
class QueueFullException extends Exception { 
  int size; 
 
  QueueFullException(int s) { size = s; } 
 
  public String toString() { 
   return "\nQueue pena. Maksymalny rozmiar: " + 
          size; 
  } 
} 
 
// Wyjtek pustej kolejki. 
class QueueEmptyException extends Exception { 
 
  public String toString() { 
   return "\nKolejka pusta."; 
  } 
}

// Kolejka znakw o staym rozmiarze wykorzystujca wyjtki. 
class FixedQueue implements ICharQ {     
  private char q[]; // tablica przechowujca elementy kolejki
  private int putloc, getloc; // indeksy operacji put i get 
     
  // Tworzy pust kolejk o podanym rozmiarze.    
  public FixedQueue(int size) {  
    q = new char[size+1]; // przydziela pami kolejce     
    putloc = getloc = 0;     
  }     
    
  // Umieszcza znak w kolejce.     
  public void put(char ch) 
    throws QueueFullException {     
 
    if(putloc==q.length-1)  
      throw new QueueFullException(q.length-1); 
         
    putloc++;     
    q[putloc] = ch;     
  }     
     
  // Pobiera znak z kolejki.    
  public char get() 
    throws QueueEmptyException {     
 
    if(getloc == putloc)  
      throw new QueueEmptyException(); 
       
    getloc++;     
    return q[getloc];     
  }     
}

// Demonstruje wyjtki kolejki.     
class QExcDemo {     
  public static void main(String args[]) {     
    FixedQueue q = new FixedQueue(10);     
    char ch;     
    int i;     
     
    try {  
      // przepenia kolejk
      for(i=0; i < 11; i++) { 
        System.out.print("Prbuj wstawi do kolejki: " + 
                         (char) ('A' + i)); 
        q.put((char) ('A' + i));     
        System.out.println(" -- OK"); 
      } 
      System.out.println(); 
    } 
    catch (QueueFullException exc) { 
      System.out.println(exc); 
    } 
    System.out.println(); 
    
    try { 
      // oprnia kolejk
      for(i=0; i < 11; i++) {      
        System.out.print("Pobieram nastpny znak: "); 
        ch = q.get();     
        System.out.println(ch);     
      } 
    } 
    catch (QueueEmptyException exc) { 
      System.out.println(exc); 
    }  
  }     
}
