// Ulepszona wersja symulacji dziaania sygnalizacji wietlnej
// przechowujca czasy trwania poszczeglnych kolorw wiate 
// w obiektach wyliczenia TrafficLightColor. 
 
// Wyliczenie stanw sygnalizatora. 
enum TrafficLightColor {  
  RED(12000), GREEN(10000), YELLOW(2000); 
 
  private int delay; 
 
  TrafficLightColor(int d) { 
    delay = d; 
  } 
 
  int getDelay() { return delay; } 
} 
 
// Skomputeryzowana sygnalizacja wietlna.
class TrafficLightSimulator implements Runnable { 
  private Thread thrd; // referencja wtku wykonujcego symulacj
  private TrafficLightColor tlc; // przechowuje biecy kolor wiata
  boolean stop = false; // warto true zatrzymuje symulacj
  boolean changed = false; // ma warto true gdy wiato zmienio si
 
  TrafficLightSimulator(TrafficLightColor init) {  
    tlc = init; 
 
    thrd = new Thread(this); 
    thrd.start(); 
  } 
 
  TrafficLightSimulator() {  
    tlc = TrafficLightColor.RED; 
 
    thrd = new Thread(this); 
    thrd.start(); 
  } 
 
  // Rozpoczyna symulacj. 
  public void run() { 
    while(!stop) { 
 
      // Zwr uwag jak uproci si ten fragment kodu! 
      try { 
        Thread.sleep(tlc.getDelay()); 
      } catch(InterruptedException exc) { 
        System.out.println(exc); 
      } 
 
      changeColor(); 
    }  
  } 
 
  // Zmienia kolor. 
  synchronized void changeColor() { 
    switch(tlc) { 
      case RED: 
        tlc = TrafficLightColor.GREEN; 
        break; 
      case YELLOW: 
        tlc = TrafficLightColor.RED; 
        break; 
      case GREEN: 
       tlc = TrafficLightColor.YELLOW; 
    } 

    changed = true; 
    notify(); // sygnalizuje, e wiato zmienio si
  } 
 
  // Czeka na zmian wiata. 
  synchronized void waitForChange() { 
    try { 
      while(!changed)
        wait(); // Czeka na zmian wiata.
      changed = false;
    } catch(InterruptedException exc) { 
      System.out.println(exc); 
    } 
  } 
 
  // Zwraca biecy kolor wiata. 
  synchronized TrafficLightColor getColor() { 
    return tlc; 
  } 
 
  // Zatrzymuje sygnalizacj. 
  synchronized void cancel() { 
    stop = true; 
  } 
}  
  
class TrafficLightDemo {  
  public static void main(String args[]) {  
    TrafficLightSimulator tl =
      new TrafficLightSimulator(TrafficLightColor.GREEN); 
 
    for(int i=0; i < 9; i++) { 
      System.out.println(tl.getColor()); 
      tl.waitForChange(); 
    } 
 
    tl.cancel(); 
  }  
}
